from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from ..process_single_embedding_command.process_single_embedding_command import ProcessSingleEmbeddingCommand, _ProcessSingleEmbeddingCommand
    from ..process_single_image_generation_command.process_single_image_generation_command import ProcessSingleImageGenerationCommand, _ProcessSingleImageGenerationCommand
    from ..process_single_prompt_command.process_single_prompt_command import ProcessSinglePromptCommand, _ProcessSinglePromptCommand
    from ..process_single_reranking_command.process_single_reranking_command import ProcessSingleRerankingCommand, _ProcessSingleRerankingCommand

'''
Translated from class com.dataiku.dip.llm.io.commands.PythonServerCommand
Via: PyModel annotation in the class hierarchy
'''


class _PythonServerCommand(TypedDict):
    pass


# List of all concrete subclasses of com.dataiku.dip.llm.io.commands.PythonServerCommand
PythonServerCommand = Union[
    'ProcessSingleEmbeddingCommand',
    'ProcessSingleImageGenerationCommand',
    'ProcessSinglePromptCommand',
    'ProcessSingleRerankingCommand',
]

# Types of class com.dataiku.dip.llm.io.commands.PythonServerCommand in PolyJSON mappings (as literal type)
PythonServerCommandTypeLiteral = Literal["process-embedding-query", "process-image-generation-query", "process-completion-query", "process-reranking-query", ]


# EOF
