from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from .finish_reason import FinishReason
    from .llm_mesh_trace_span import LLMMeshTraceSpan, _LLMMeshTraceSpan
    from .total_usage import TotalUsage, _TotalUsage

'''
Translated from class com.dataiku.dip.llm.online.LLMClient$StreamedCompletionResponseFooter
Via: com.dataiku.dip.llm.io.commands.StreamResponseChunkOrFooter
'''


class _StreamedCompletionResponseFooter(TypedDict):
    additionalInformation: Dict[str, Any]
    completionTokens: int
    contextUpsert: Dict[str, Any]
    estimatedCost: float
    finishReason: 'FinishReason'
    promptTokens: int
    tokenCountsAreEstimated: bool
    totalTokens: int
    totalUsage: 'TotalUsage'
    trace: 'LLMMeshTraceSpan'
    type: str


StreamedCompletionResponseFooter = _StreamedCompletionResponseFooter


# EOF
