# encoding: utf-8
"""
Executor for containerized execution of python agent evaluation recipe.
"""

import logging, json

from dataiku.base.utils import ErrorMonitoringWrapper
from dataiku.container.runner import setup_log
from dataiku.container.runner import read_execution


if __name__ == "__main__":
    setup_log()
    execution = read_execution()
    execution_id = execution['id']

    with ErrorMonitoringWrapper():
        payload = json.loads(execution['payload'])

        logging.info("Running agent evaluation recipe main")
        if execution['type'] == 'RECIPE_AGENT_EVALUATION_PYTHON':
            from dataiku.llm.evaluation.agent_evaluation_recipe import AgentEvaluationRecipe
            runner = AgentEvaluationRecipe.build(
                execution["executionPath"],
                payload.get("modelEvaluationFolder"),
                payload.get("inputDatasetSmartName"),
                payload.get("outputDatasetSmartName"),
                payload.get("metricsDatasetSmartName"),
                payload.get("ragasMaxWorkers")
            )
            runner.run()
        else:
            raise Exception("Unsupported agent eval recipe type: %s" % execution['type'])
