from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from ....grouping.grouping.grouping import Grouping, _Grouping
    from ....stats.alternative_hypothesis.alternative_hypothesis import AlternativeHypothesis
    from ....stats.p_value_adjustment_method.p_value_adjustment_method import PValueAdjustmentMethod
    from ....stats.variance_assumption.variance_assumption import VarianceAssumption
from ...computation.univariate_computation import UnivariateComputation, _UnivariateComputation

'''
Translated from class com.dataiku.dip.eda.compute.computations.univariate.PairwiseTTest
Via: PyModel annotation in the class hierarchy
'''


class _PairwiseTTest(_UnivariateComputation, TypedDict):
    type: Literal["pairwise_ttest"]
    adjustmentMethod: 'PValueAdjustmentMethod'
    alternative: 'AlternativeHypothesis'
    confidenceLevel: float
    grouping: 'Grouping'
    oneVsAll: bool
    varianceAssumption: 'VarianceAssumption'


PairwiseTTest = _PairwiseTTest


# EOF
