from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from ...governance.guardrails_pipeline_settings.guardrails_pipeline_settings import GuardrailsPipelineSettings, _GuardrailsPipelineSettings
    from .image_generation_edition_mode import ImageGenerationEditionMode
    from .image_generation_mask_mode import ImageGenerationMaskMode
    from .image_generation_prompt import ImageGenerationPrompt, _ImageGenerationPrompt

'''
Translated from class com.dataiku.dip.llm.online.LLMClient$ImageGenerationQuery
Via: com.dataiku.dip.llm.io.commands.ProcessSingleImageGenerationCommand
'''


class _ImageGenerationQuery(TypedDict):
    fidelity: float
    guardrails: 'GuardrailsPipelineSettings'
    height: int
    llmId: str
    maskImage: str
    maskMode: 'ImageGenerationMaskMode'
    maskPrompt: str
    nbImagesToGenerate: int
    negativePrompts: List['ImageGenerationPrompt']
    originalImage: str
    originalImageEditionMode: 'ImageGenerationEditionMode'
    originalImagePath: str
    originalImageWeight: float
    prompts: List['ImageGenerationPrompt']
    quality: str
    seed: int
    style: str
    width: int


ImageGenerationQuery = _ImageGenerationQuery


# EOF
