from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from .image_generation_image import ImageGenerationImage, _ImageGenerationImage
    from .image_generation_response_or_error import ImageGenerationResponseOrError, _ImageGenerationResponseOrError
    from .llm_mesh_trace_span import LLMMeshTraceSpan, _LLMMeshTraceSpan
    from .total_usage import TotalUsage, _TotalUsage

'''
Translated from class com.dataiku.dip.llm.online.LLMClient$ImageGenerationResponse
Via: PyModel annotation in the class hierarchy
'''


class _ImageGenerationResponse(TypedDict):
    additionalInformation: Dict[str, Any]
    estimatedCost: float
    images: List['ImageGenerationImage']
    totalUsage: 'TotalUsage'
    trace: 'LLMMeshTraceSpan'


# List of all concrete subclasses of com.dataiku.dip.llm.online.LLMClient$ImageGenerationResponse
ImageGenerationResponse = Union[
    '_ImageGenerationResponse',
    'ImageGenerationResponseOrError',
]


# EOF
