/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.partition;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.hadoop.util.UTF8ByteArrayUtils;

class KeyFieldHelper {
    private List<KeyDescription> allKeySpecs = new ArrayList<KeyDescription>();
    private byte[] keyFieldSeparator;
    private boolean keySpecSeen = false;

    KeyFieldHelper() {
    }

    public void setKeyFieldSeparator(String keyFieldSeparator) {
        this.keyFieldSeparator = keyFieldSeparator.getBytes(StandardCharsets.UTF_8);
    }

    public void setKeyFieldSpec(int start, int end) {
        if (end >= start) {
            KeyDescription k = new KeyDescription();
            k.beginFieldIdx = start;
            k.endFieldIdx = end;
            this.keySpecSeen = true;
            this.allKeySpecs.add(k);
        }
    }

    public List<KeyDescription> keySpecs() {
        return this.allKeySpecs;
    }

    public int[] getWordLengths(byte[] b, int start, int end) {
        int pos;
        if (!this.keySpecSeen) {
            return new int[]{1};
        }
        int[] lengths = new int[10];
        int currLenLengths = lengths.length;
        int idx = 1;
        while ((pos = UTF8ByteArrayUtils.findBytes(b, start, end, this.keyFieldSeparator)) != -1) {
            if (++idx == currLenLengths) {
                int[] temp = lengths;
                lengths = new int[currLenLengths *= 2];
                System.arraycopy(temp, 0, lengths, 0, temp.length);
            }
            lengths[idx - 1] = pos - start;
            start = pos + 1;
        }
        if (start != end) {
            lengths[idx] = end - start;
        }
        lengths[0] = idx;
        return lengths;
    }

    public int getStartOffset(byte[] b, int start, int end, int[] lengthIndices, KeyDescription k) {
        if (lengthIndices[0] >= k.beginFieldIdx) {
            int position = 0;
            for (int i = 1; i < k.beginFieldIdx; ++i) {
                position += lengthIndices[i] + this.keyFieldSeparator.length;
            }
            if (position + k.beginChar <= end - start) {
                return start + position + k.beginChar - 1;
            }
        }
        return -1;
    }

    public int getEndOffset(byte[] b, int start, int end, int[] lengthIndices, KeyDescription k) {
        if (k.endFieldIdx == 0) {
            return end - 1;
        }
        if (lengthIndices[0] >= k.endFieldIdx) {
            int i;
            int position = 0;
            for (i = 1; i < k.endFieldIdx; ++i) {
                position += lengthIndices[i] + this.keyFieldSeparator.length;
            }
            if (k.endChar == 0) {
                position += lengthIndices[i];
            }
            if (position + k.endChar <= end - start) {
                return start + position + k.endChar - 1;
            }
            return end - 1;
        }
        return end - 1;
    }

    public void parseOption(String option) {
        if (option == null || option.equals("")) {
            return;
        }
        StringTokenizer args = new StringTokenizer(option);
        KeyDescription global = new KeyDescription();
        while (args.hasMoreTokens()) {
            KeyDescription k;
            String arg = args.nextToken();
            if (arg.equals("-n")) {
                global.numeric = true;
            }
            if (arg.equals("-r")) {
                global.reverse = true;
            }
            if (arg.equals("-nr")) {
                global.numeric = true;
                global.reverse = true;
            }
            if (!arg.startsWith("-k") || (k = this.parseKey(arg, args)) == null) continue;
            this.allKeySpecs.add(k);
            this.keySpecSeen = true;
        }
        for (KeyDescription key : this.allKeySpecs) {
            if (key.reverse | key.numeric) continue;
            key.reverse = global.reverse;
            key.numeric = global.numeric;
        }
        if (this.allKeySpecs.size() == 0) {
            this.allKeySpecs.add(global);
        }
    }

    private KeyDescription parseKey(String arg, StringTokenizer args) {
        String token;
        String keyArgs = null;
        if (arg.length() == 2) {
            if (args.hasMoreTokens()) {
                keyArgs = args.nextToken();
            }
        } else {
            keyArgs = arg.substring(2);
        }
        if (keyArgs == null || keyArgs.length() == 0) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(keyArgs, "nr.,", true);
        KeyDescription key = new KeyDescription();
        if (st.hasMoreTokens()) {
            token = st.nextToken();
            key.beginFieldIdx = Integer.parseInt(token);
        }
        if (st.hasMoreTokens()) {
            block22: {
                token = st.nextToken();
                if (token.equals(".")) {
                    token = st.nextToken();
                    key.beginChar = Integer.parseInt(token);
                    if (st.hasMoreTokens()) {
                        token = st.nextToken();
                    } else {
                        return key;
                    }
                }
                while (true) {
                    if (token.equals("n")) {
                        key.numeric = true;
                    } else {
                        if (!token.equals("r")) break block22;
                        key.reverse = true;
                    }
                    if (!st.hasMoreTokens()) break;
                    token = st.nextToken();
                }
                return key;
            }
            if (token.equals(",")) {
                token = st.nextToken();
                key.endFieldIdx = Integer.parseInt(token);
                if (st.hasMoreTokens()) {
                    token = st.nextToken();
                    if (token.equals(".")) {
                        token = st.nextToken();
                        key.endChar = Integer.parseInt(token);
                        if (st.hasMoreTokens()) {
                            token = st.nextToken();
                        } else {
                            return key;
                        }
                    }
                    while (true) {
                        if (token.equals("n")) {
                            key.numeric = true;
                        } else if (token.equals("r")) {
                            key.reverse = true;
                        } else {
                            throw new IllegalArgumentException("Invalid -k argument. Must be of the form -k pos1,[pos2], where pos is of the form f[.c]nr");
                        }
                        if (!st.hasMoreTokens()) break;
                        token = st.nextToken();
                    }
                }
                return key;
            }
            throw new IllegalArgumentException("Invalid -k argument. Must be of the form -k pos1,[pos2], where pos is of the form f[.c]nr");
        }
        return key;
    }

    private void printKey(KeyDescription key) {
        System.out.println("key.beginFieldIdx: " + key.beginFieldIdx);
        System.out.println("key.beginChar: " + key.beginChar);
        System.out.println("key.endFieldIdx: " + key.endFieldIdx);
        System.out.println("key.endChar: " + key.endChar);
        System.out.println("key.numeric: " + key.numeric);
        System.out.println("key.reverse: " + key.reverse);
        System.out.println("parseKey over");
    }

    protected static class KeyDescription {
        int beginFieldIdx = 1;
        int beginChar = 1;
        int endFieldIdx = 0;
        int endChar = 0;
        boolean numeric;
        boolean reverse;

        protected KeyDescription() {
        }

        public String toString() {
            return "-k" + this.beginFieldIdx + "." + this.beginChar + "," + this.endFieldIdx + "." + this.endChar + (this.numeric ? "n" : "") + (this.reverse ? "r" : "");
        }
    }
}

