/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.unsafe.map;

public interface HashMapGrowthStrategy {
    public static final HashMapGrowthStrategy DOUBLING = new Doubling();

    public int nextCapacity(int var1);

    public static class Doubling
    implements HashMapGrowthStrategy {
        private static final int ARRAY_MAX = 0x7FFFFFF0;

        @Override
        public int nextCapacity(int currentCapacity) {
            assert (currentCapacity > 0);
            int doubleCapacity = currentCapacity * 2;
            return doubleCapacity > 0 && doubleCapacity <= 0x7FFFFFF0 ? doubleCapacity : 0x7FFFFFF0;
        }
    }
}

